package gui;

import java.awt.EventQueue;

import javax.swing.JFrame;
import javax.swing.JPanel;
import java.awt.BorderLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Color;
import net.miginfocom.swing.MigLayout;
import util.Utility;

import javax.swing.JTextField;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JTextArea;
import javax.swing.JButton;
import java.awt.Dimension;
import javax.swing.JRadioButton;
import javax.swing.ButtonGroup;
import javax.swing.JSplitPane;
import javax.swing.JScrollPane;
import javax.swing.ImageIcon;
import javax.swing.SwingConstants;
import javax.swing.filechooser.FileNameExtensionFilter;

import music.Album;
import music.Performer;
import music.Song;

import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.awt.event.ActionEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.awt.event.ItemEvent;
import javax.swing.JMenuBar;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class GUI {

	private JFrame frmSgtPapper;
	private JPanel northPanel;
	private JPanel westPanel;
	private JPanel southPanel;
	private JPanel eastPanel;
	private JPanel centralPanel;
	private JLabel lblAlbum;
	private JLabel lblTitle;
	private JTextField titleTextField;
	private JLabel lblPerformer;
	private JTextField performerTextField;
	private JLabel lblSongs;
	private JComboBox songsComboBox;
	private JLabel lblReleaseDate;
	private JLabel lblSpecificReleaseDate;
	private JLabel lblCredits;
	private JTextArea creditsTextArea;
	private JButton btnSave;
	private JRadioButton rdbtnBasic;
	private JRadioButton rdbtnStandard;
	private JRadioButton rdbtnAll;
	private JLabel lblDetails;
	private final ButtonGroup buttonGroup = new ButtonGroup();
	private JSplitPane centralSplitPane;
	private JScrollPane leftScrollPane;
	private JScrollPane rightScrollPane;
	private JTextArea lyricsTextArea;
	private JLabel lblPicture;
	
	private Album album;
	private LinkedList<Song> songs = new LinkedList<Song>();
	private JButton btnTest;
	private Song song;
	private NewSongDialog newSongDialog;
	private JMenuBar menuBar;
	private JMenu mnFile;
	private JMenu mnEdit;
	private JMenu mnHelp;
	private JMenuItem mntmNewAlbum;
	private JMenuItem mntmNewSong;
	private JMenuItem mntmOpen;
	private JMenuItem mntmSave;
	private JMenuItem mntmExit;

	/**
	 * Launch the application.
	 */
	public static void main(String[] args) {
		EventQueue.invokeLater(new Runnable() {
			public void run() {
				try {
					GUI window = new GUI();
					window.frmSgtPapper.setVisible(true);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
	}

	/**
	 * Create the application.
	 */
	public GUI() {
		initialize();
	}

	/**
	 * Initialize the contents of the frame.
	 */
	private void initialize() {
		frmSgtPapper = new JFrame();
		frmSgtPapper.setTitle("Sgt. Papper");
		frmSgtPapper.setBounds(100, 100, 658, 492);
		frmSgtPapper.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frmSgtPapper.getContentPane().add(getNorthPanel(), BorderLayout.NORTH);
		frmSgtPapper.getContentPane().add(getWestPanel(), BorderLayout.WEST);
		frmSgtPapper.getContentPane().add(getSouthPanel(), BorderLayout.SOUTH);
		frmSgtPapper.getContentPane().add(getEastPanel(), BorderLayout.EAST);
		frmSgtPapper.getContentPane().add(getCentralPanel(), BorderLayout.CENTER);
		frmSgtPapper.setJMenuBar(getMenuBar());
		createResourcesDir();
		populateSongsComboBox();
		lblSpecificReleaseDate.setForeground(Color.GRAY);
		lblSpecificReleaseDate.setText("01.06.1967");
		String[] date = lblSpecificReleaseDate.getText().split("\\.");
		GregorianCalendar releaseDate = new GregorianCalendar(
				Integer.parseInt(date[2]), 
				(Integer.parseInt(date[1]) - 1), 
				Integer.parseInt(date[0]));
		album.setReleaseDate(releaseDate);
	}
	
	private void createResourcesDir() {
		Utility.getSubdir("resources");
	}
	
	private void populateSongsComboBox() {
//		getSongsComboBox().addItem("Sgt. Pepper");
//		getSongsComboBox().addItem("With...");
//		getSongsComboBox().addItem("Lucy...");
		album = Album.deserialize(Utility.getSubdir("resources") + "\\sgt.serialized");
		for (int i = 0; i < album.getSongs().length; i++) {
			getSongsComboBox().addItem(album.getSongs()[i].getTitle());
		}
	}
	
	private Album getAlbum() {
		if (album == null) {
			album = new Album();
			album.setTitle(titleTextField.getText());
			Performer p = new Performer();
			p.setName(performerTextField.getText());
			album.setPerformer(p);
			album.setSongs(songs.toArray(new Song[0]));
			String creditsText = creditsTextArea.getText();
			ArrayList<String> credits = new ArrayList<String>();
			credits.add(creditsText);
			album.setCredits(credits);
		}
		return album;
	}
	private JPanel getNorthPanel() {
		if (northPanel == null) {
			northPanel = new JPanel();
			FlowLayout flowLayout = (FlowLayout) northPanel.getLayout();
			northPanel.add(getLblAlbum());
		}
		return northPanel;
	}
	private JPanel getWestPanel() {
		if (westPanel == null) {
			westPanel = new JPanel();
			westPanel.setLayout(new MigLayout("", "[grow]", "[][][][][][][grow][]"));
			westPanel.add(getLblTitle(), "cell 0 0");
			westPanel.add(getTitleTextField(), "cell 0 1,growx");
			westPanel.add(getLblPerformer(), "cell 0 2");
			westPanel.add(getPerformerTextField(), "cell 0 3,growx");
			westPanel.add(getLblSongs(), "cell 0 4");
			westPanel.add(getSongsComboBox(), "cell 0 5,growx");
			westPanel.add(getBtnTest(), "cell 0 7");
		}
		return westPanel;
	}
	private JPanel getSouthPanel() {
		if (southPanel == null) {
			southPanel = new JPanel();
			southPanel.setLayout(new MigLayout("", "[grow][][][][grow]", "[][]"));
			southPanel.add(getLblDetails(), "cell 1 0 3 1,alignx center");
			southPanel.add(getRdbtnBasic(), "cell 1 1");
			southPanel.add(getRdbtnStandard(), "cell 2 1");
			southPanel.add(getRdbtnAll(), "cell 3 1");
		}
		return southPanel;
	}
	private JPanel getEastPanel() {
		if (eastPanel == null) {
			eastPanel = new JPanel();
			eastPanel.setPreferredSize(new Dimension(150, 10));
			eastPanel.setForeground(new Color(0, 191, 255));
			eastPanel.setLayout(new MigLayout("", "[grow]", "[][][][grow][]"));
			eastPanel.add(getLblReleaseDate(), "cell 0 0");
			eastPanel.add(getLblSpecificReleaseDate(), "cell 0 1");
			eastPanel.add(getLblCredits(), "cell 0 2");
			eastPanel.add(getCreditsTextArea(), "cell 0 3,grow");
			eastPanel.add(getBtnSave(), "cell 0 4,alignx right");
		}
		return eastPanel;
	}
	private JPanel getCentralPanel() {
		if (centralPanel == null) {
			centralPanel = new JPanel();
			centralPanel.setLayout(new MigLayout("", "[grow]", "[grow]"));
			centralPanel.add(getCentralSplitPane(), "cell 0 0,grow");
		}
		return centralPanel;
	}
	private JLabel getLblAlbum() {
		if (lblAlbum == null) {
			lblAlbum = new JLabel("Album");
			lblAlbum.setForeground(new Color(0, 128, 128));
			lblAlbum.setFont(new Font("Tahoma", Font.BOLD, 14));
		}
		return lblAlbum;
	}
	private JLabel getLblTitle() {
		if (lblTitle == null) {
			lblTitle = new JLabel("Title");
		}
		return lblTitle;
	}
	private JTextField getTitleTextField() {
		if (titleTextField == null) {
			titleTextField = new JTextField();
			titleTextField.setColumns(10);
		}
		return titleTextField;
	}
	private JLabel getLblPerformer() {
		if (lblPerformer == null) {
			lblPerformer = new JLabel("Performer");
		}
		return lblPerformer;
	}
	private JTextField getPerformerTextField() {
		if (performerTextField == null) {
			performerTextField = new JTextField();
			performerTextField.setColumns(10);
		}
		return performerTextField;
	}
	private JLabel getLblSongs() {
		if (lblSongs == null) {
			lblSongs = new JLabel("Songs");
		}
		return lblSongs;
	}
	private JComboBox getSongsComboBox() {
		if (songsComboBox == null) {
			songsComboBox = new JComboBox();
			songsComboBox.addItemListener(new ItemListener() {
				public void itemStateChanged(ItemEvent arg0) {
					if (arg0.getStateChange() == ItemEvent.SELECTED) {
						lyricsTextArea.setForeground(Color.BLACK);
						String title = (String) songsComboBox.getSelectedItem();
						for (int i = 0; i < album.getSongs().length; i++) {
							if (title.equals(album.getSongs()[i].getTitle())) {
								lyricsTextArea.setText(album.getSongs()[i].getLyrics());
								break;
							}
						}
					}
				}
			});
		}
		return songsComboBox;
	}
	private JLabel getLblReleaseDate() {
		if (lblReleaseDate == null) {
			lblReleaseDate = new JLabel("Release date");
		}
		return lblReleaseDate;
	}
	private JLabel getLblSpecificReleaseDate() {
		if (lblSpecificReleaseDate == null) {
			lblSpecificReleaseDate = new JLabel("");
		}
		return lblSpecificReleaseDate;
	}
	private JLabel getLblCredits() {
		if (lblCredits == null) {
			lblCredits = new JLabel("Credits");
		}
		return lblCredits;
	}
	private JTextArea getCreditsTextArea() {
		if (creditsTextArea == null) {
			creditsTextArea = new JTextArea();
		}
		return creditsTextArea;
	}
	private JButton getBtnSave() {
		if (btnSave == null) {
			btnSave = new JButton("Save");
			btnSave.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent arg0) {
					album = getAlbum();
				    JFileChooser chooser = new JFileChooser();
				    FileNameExtensionFilter filter = new FileNameExtensionFilter(
				        "Serialized album files", "serialized", "serial");
				    chooser.setFileFilter(filter);
				    chooser.setCurrentDirectory(new File(Utility.getSubdir("resources")));
				    int returnVal = chooser.showOpenDialog(frmSgtPapper);
				    if(returnVal == JFileChooser.APPROVE_OPTION) {
				    	album.serialize(Utility.getSubdir("resources") + "\\" + chooser.getSelectedFile().getName());
						JOptionPane.showMessageDialog(frmSgtPapper,
							    "Album saved.");
//				       System.out.println("You chose to open this file: " +
//				            chooser.getSelectedFile().getName());
				    }
//					Album album1 = Album.deserialize(Utility.getSubdir("resources") + "\\sgt.serialized");
//					System.out.println(album1);
				}
			});
		}
		return btnSave;
	}
    private JRadioButton getRdbtnBasic() {
        if (rdbtnBasic == null) {
        	rdbtnBasic = new JRadioButton("Basic");
        	rdbtnBasic.addItemListener(new ItemListener() {
        	    public void itemStateChanged(ItemEvent arg0) {
        	        getCentralPanel().setVisible(false);
        	        getLblReleaseDate().setVisible(false);
        	        getLblSpecificReleaseDate().setVisible(false);
        	        getLblCredits().setVisible(false);
        	        getCreditsTextArea().setVisible(false);
        	        getBtnSave().setVisible(false);
        	    }
        	});
        	buttonGroup.add(rdbtnBasic);
//        	rdbtnBasic.setSelected(true);
        }
        return rdbtnBasic;
    }
    private JRadioButton getRdbtnStandard() {
        if (rdbtnStandard == null) {
        	rdbtnStandard = new JRadioButton("Standard");
        	rdbtnStandard.addItemListener(new ItemListener() {
        	    public void itemStateChanged(ItemEvent arg0) {
                    getCentralPanel().setVisible(true);
                    getLblReleaseDate().setVisible(false);
                    getLblSpecificReleaseDate().setVisible(false);
                    getLblCredits().setVisible(false);
                    getCreditsTextArea().setVisible(false);
                    getBtnSave().setVisible(false);
        	    }
        	});
        	buttonGroup.add(rdbtnStandard);
        	rdbtnStandard.setSelected(true);
        }
        return rdbtnStandard;
    }
    private JRadioButton getRdbtnAll() {
        if (rdbtnAll == null) {
        	rdbtnAll = new JRadioButton("All");
        	rdbtnAll.addActionListener(new ActionListener() {
        	    public void actionPerformed(ActionEvent arg0) {
                    getCentralPanel().setVisible(true);
                    getLblReleaseDate().setVisible(true);
                    getLblSpecificReleaseDate().setVisible(true);
                    getLblCredits().setVisible(true);
                    getCreditsTextArea().setVisible(true);
                    getBtnSave().setVisible(true);
        	    }
        	});
        	buttonGroup.add(rdbtnAll);
        }
        return rdbtnAll;
    }
	private JLabel getLblDetails() {
		if (lblDetails == null) {
			lblDetails = new JLabel("Details");
		}
		return lblDetails;
	}
	private JSplitPane getCentralSplitPane() {
		if (centralSplitPane == null) {
			centralSplitPane = new JSplitPane();
			centralSplitPane.setLeftComponent(getLeftScrollPane());
			centralSplitPane.setRightComponent(getRightScrollPane());
			centralSplitPane.setDividerLocation(130);
			centralSplitPane.setOneTouchExpandable(true);
		}
		return centralSplitPane;
	}
	private JScrollPane getLeftScrollPane() {
		if (leftScrollPane == null) {
			leftScrollPane = new JScrollPane();
			leftScrollPane.setViewportView(getLyricsTextArea());
		}
		return leftScrollPane;
	}
	private JScrollPane getRightScrollPane() {
		if (rightScrollPane == null) {
			rightScrollPane = new JScrollPane();
			rightScrollPane.setViewportView(getLblPicture());
		}
		return rightScrollPane;
	}
	private JTextArea getLyricsTextArea() {
		if (lyricsTextArea == null) {
			lyricsTextArea = new JTextArea();
		}
		lyricsTextArea.setLineWrap(true);
		lyricsTextArea.setWrapStyleWord(true);
		return lyricsTextArea;
	}
	private JLabel getLblPicture() {
		if (lblPicture == null) {
			lblPicture = new JLabel("");
			lblPicture.setHorizontalAlignment(SwingConstants.CENTER);
			lblPicture.setIcon(new ImageIcon("C:\\Users\\student1\\Desktop\\V\\Sgt. Pepper\\resources\\sgt.jpg"));
		}
		return lblPicture;
	}
	private JButton getBtnTest() {
		if (btnTest == null) {
			btnTest = new JButton("Test");
			btnTest.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					Song s = new Song();
					s.setTitle((String) songsComboBox.getSelectedItem());
					s.setLyrics(lyricsTextArea.getText());
					songs.add(s);
					JOptionPane.showMessageDialog(frmSgtPapper,
						    "Song saved.");
				}
			});
		}
		return btnTest;
	}
	private JMenuBar getMenuBar() {
		if (menuBar == null) {
			menuBar = new JMenuBar();
			menuBar.add(getMnFile());
			menuBar.add(getMnEdit());
			menuBar.add(getMnHelp());
		}
		return menuBar;
	}
	private JMenu getMnFile() {
		if (mnFile == null) {
			mnFile = new JMenu("File");
			mnFile.add(getMntmNewAlbum());
			mnFile.add(getMntmNewSong());
			mnFile.add(getMntmOpen());
			mnFile.add(getMntmSave());
			mnFile.add(getMntmExit());
		}
		return mnFile;
	}
	private JMenu getMnEdit() {
		if (mnEdit == null) {
			mnEdit = new JMenu("Edit");
		}
		return mnEdit;
	}
	private JMenu getMnHelp() {
		if (mnHelp == null) {
			mnHelp = new JMenu("Help");
		}
		return mnHelp;
	}
	private JMenuItem getMntmNewAlbum() {
		if (mntmNewAlbum == null) {
			mntmNewAlbum = new JMenuItem("New album...");
		}
		return mntmNewAlbum;
	}
	private JMenuItem getMntmNewSong() {
		if (mntmNewSong == null) {
			mntmNewSong = new JMenuItem("New song...");
			mntmNewSong.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					newSongDialog = new NewSongDialog(frmSgtPapper, true);
					song = newSongDialog.showDialog();
					if (song != null) {
						if (isNewSongOK(song)) {
							songs.add(song);
							songsComboBox.addItem(song.getTitle());
							songsComboBox.setSelectedIndex(songsComboBox.getItemCount() - 1);
							lyricsTextArea.setText(song.getLyrics());
						} else {
							songsComboBox.setSelectedIndex(-1);
							lyricsTextArea.setForeground(Color.RED);
							lyricsTextArea.setText("Something went wrong...");
						}
					}
				}
			});
		}
		return mntmNewSong;
	}
	private JMenuItem getMntmOpen() {
		if (mntmOpen == null) {
			mntmOpen = new JMenuItem("Open...");
		}
		return mntmOpen;
	}
	private JMenuItem getMntmSave() {
		if (mntmSave == null) {
			mntmSave = new JMenuItem("Save...");
		}
		return mntmSave;
	}
	private JMenuItem getMntmExit() {
		if (mntmExit == null) {
			mntmExit = new JMenuItem("Exit");
			mntmExit.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					System.exit(0);
				}
			});
		}
		return mntmExit;
	}
	private boolean isNewSongOK(Song s) {
		if (s != null) {
			if ((!s.getTitle().equals(null)) && (!s.getTitle().equals("")) &&
				((!s.getLyrics().equals(null)) && (!s.getLyrics().equals("")))) {
				return true;
			}
		}
		return false;
	}
}
